#!/bin/bash

# 更新现有的包列表
sudo apt update

# 安装依赖包
sudo apt install -y apt-transport-https ca-certificates curl software-properties-common

# 添加 Docker 的官方 GPG 密钥
curl -fsSL https://download.docker.com/linux/ubuntu/gpg | sudo apt-key add -

# 设置 Docker 仓库
sudo add-apt-repository "deb [arch=amd64] https://download.docker.com/linux/ubuntu $(lsb_release -cs) stable"

# 更新包列表
sudo apt update

# 安装 Docker
sudo apt install -y docker-ce

# 启动 Docker 并设置为开机自启
sudo systemctl start docker
sudo systemctl enable docker

# 验证 Docker 安装
sudo docker run hello-world

echo "Docker 已成功安装并运行！"
